/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.model;

import java.util.Iterator;
import java.util.TreeSet;
import net.raphimc.noteblocklib.format.SongFormat;
import net.raphimc.noteblocklib.model.Notes;
import net.raphimc.noteblocklib.model.TempoEvents;

public abstract class Song {
    private final SongFormat format;
    private Notes notes = new Notes();
    private TempoEvents tempoEvents = new TempoEvents();
    private final String fileName;
    private String title;
    private String author;
    private String originalAuthor;
    private String description;

    protected Song(SongFormat format, String fileName) {
        this.format = format;
        this.fileName = fileName;
    }

    public int getLengthInMilliseconds() {
        return this.tickToMilliseconds(this.notes.getLengthInTicks());
    }

    public int getLengthInSeconds() {
        return (int)Math.ceil((float)this.getLengthInMilliseconds() / 1000.0f);
    }

    public String getHumanReadableLength() {
        int length = this.getLengthInSeconds();
        return String.format("%02d:%02d:%02d", length / 3600, length / 60 % 60, length % 60);
    }

    public int tickToMilliseconds(int tick) {
        int tempoTick;
        TreeSet<Integer> tempoEventTicks = new TreeSet<Integer>(this.tempoEvents.getTicks());
        tempoEventTicks.add(tick);
        int lastTick = 0;
        float totalMilliseconds = 0.0f;
        Iterator iterator = tempoEventTicks.iterator();
        while (iterator.hasNext() && (tempoTick = ((Integer)iterator.next()).intValue()) <= tick) {
            float tps = this.tempoEvents.getEffectiveTempo(lastTick);
            int ticksInSegment = tempoTick - lastTick;
            float segmentMilliseconds = (float)ticksInSegment / tps * 1000.0f;
            totalMilliseconds += segmentMilliseconds;
            lastTick = tempoTick;
        }
        return (int)Math.ceil(totalMilliseconds);
    }

    public int millisecondsToTick(int milliseconds) {
        TreeSet<Integer> tempoEventTicks = new TreeSet<Integer>(this.tempoEvents.getTicks());
        tempoEventTicks.add(this.notes.getLengthInTicks());
        int lastTick = 0;
        float totalMilliseconds = 0.0f;
        Iterator iterator = tempoEventTicks.iterator();
        while (iterator.hasNext()) {
            float tps;
            int tempoTick = (Integer)iterator.next();
            int ticksInSegment = tempoTick - lastTick;
            float segmentMilliseconds = (float)ticksInSegment / (tps = this.tempoEvents.getEffectiveTempo(lastTick)) * 1000.0f;
            if (totalMilliseconds + segmentMilliseconds >= (float)milliseconds) {
                float remainingMilliseconds = (float)milliseconds - totalMilliseconds;
                int ticksToAdd = Math.round(remainingMilliseconds / 1000.0f * tps);
                return lastTick + ticksToAdd;
            }
            totalMilliseconds += segmentMilliseconds;
            lastTick = tempoTick;
        }
        return this.notes.getLengthInTicks();
    }

    public SongFormat getFormat() {
        return this.format;
    }

    public Notes getNotes() {
        return this.notes;
    }

    public TempoEvents getTempoEvents() {
        return this.tempoEvents;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameOr(String fallback) {
        return this.fileName == null ? fallback : this.fileName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleOr(String fallback) {
        return this.title == null ? fallback : this.title;
    }

    public Song setTitle(String title) {
        this.title = title != null && !title.isEmpty() ? title : null;
        return this;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getAuthorOr(String fallback) {
        return this.author == null ? fallback : this.author;
    }

    public Song setAuthor(String author) {
        this.author = author != null && !author.isEmpty() ? author : null;
        return this;
    }

    public String getOriginalAuthor() {
        return this.originalAuthor;
    }

    public String getOriginalAuthorOr(String fallback) {
        return this.originalAuthor == null ? fallback : this.originalAuthor;
    }

    public Song setOriginalAuthor(String originalAuthor) {
        this.originalAuthor = originalAuthor != null && !originalAuthor.isEmpty() ? originalAuthor : null;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionOr(String fallback) {
        return this.description == null ? fallback : this.description;
    }

    public Song setDescription(String description) {
        this.description = description != null && !description.isEmpty() ? description : null;
        return this;
    }

    public String getTitleOrFileName() {
        return this.title == null ? this.fileName : this.title;
    }

    public String getTitleOrFileNameOr(String fallback) {
        return this.getTitleOrFileName() == null ? fallback : this.getTitleOrFileName();
    }

    public void copyGeneralData(Song song) {
        this.notes = song.getNotes().copy();
        this.tempoEvents = song.getTempoEvents().copy();
        this.setTitle(song.getTitle());
        this.setAuthor(song.getAuthor());
        this.setOriginalAuthor(song.getOriginalAuthor());
        this.setDescription(song.getDescription());
    }

    public abstract Song copy();
}

